close all;
clear all;
rng('default')
s=rng;

n=10;
a=0.5;
b=2;

niter=100;
X=gamrnd(a,b,[niter,n]);
writematrix(X,sprintf('%s_%d%s','mean_est_original_n',n,'.xlsx'))
mu=0.5;
alpha=log(normcdf(0.5*mu)/(1-normcdf(0.5*mu)));

k=2:60;
niter=100;

nonpriv_err=zeros([niter,length(k)]);
mean_alpha_err=zeros([niter,length(k)]);
mean_alpha_2_err=zeros([niter,length(k)]);
mean_alpha_4_err=zeros([niter,length(k)]);
mean_alpha_8_err=zeros([niter,length(k)]);
mean_alpha_16_err=zeros([niter,length(k)]);
mean_gdp_err=zeros([niter,length(k)]);
mean_gdp_2_err=zeros([niter,length(k)]);

mean_est_nonpriv=zeros([niter,length(k)]);
mean_est_alpha=zeros([niter,length(k)]);
mean_est_alpha_2=zeros([niter,length(k)]);
mean_est_alpha_4=zeros([niter,length(k)]);
mean_est_alpha_8=zeros([niter,length(k)]);
mean_est_alpha_16=zeros([niter,length(k)]);
mean_est_gdp=zeros([niter,length(k)]);
mean_est_gdp_2=zeros([niter,length(k)]);
for i=1:length(k)
    for j=1:niter
        mean_est_nonpriv(j,i)=mean(X(j,:));
        nonpriv_err(j,i)=(mean(X(j,:))-a*b)^2;
        %Laplacian alpha
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*alpha^2)^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+laprnd(1,n,0,2*T/alpha);
        mean_est_alpha(j,i)=mean(Z);
        mean_alpha_err(j,i)=(mean(Z)-a*b)^2;
        %Laplacian alpha*2
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*(2*alpha)^2)^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+laprnd(1,n,0,2*T/(2*alpha));
        mean_est_alpha_2(j,i)=mean(Z);
        mean_alpha_2_err(j,i)=(mean(Z)-a*b)^2;
        %Laplacian alpha*4
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*(4*alpha)^2)^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+laprnd(1,n,0,2*T/(4*alpha));
        mean_est_alpha_4(j,i)=mean(Z);
        mean_alpha_4_err(j,i)=(mean(Z)-a*b)^2;
        %Laplacian alpha*8
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*(8*alpha)^2)^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+laprnd(1,n,0,2*T/(8*alpha));
        mean_est_alpha_8(j,i)=mean(Z);
        mean_alpha_8_err(j,i)=(mean(Z)-a*b)^2;
        %Laplacian alpha*16
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*(16*alpha)^2)^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+laprnd(1,n,0,2*T/(16*alpha));
        mean_est_alpha_16(j,i)=mean(Z);
        mean_alpha_16_err(j,i)=(mean(Z)-a*b)^2;
        %GDP mu
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*(1+4/(mu)^2)^(-1))^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+normrnd(0,2*T/(mu),[1,n]);
        mean_est_gdp(j,i)=mean(Z);
        mean_gdp_err(j,i)=(mean(Z)-a*b)^2;
        %GDP mu*2
        r=b^k(i)*gamma(k(i)+a)/gamma(a);
        T=(r*n*(1+4/(mu*2)^2)^(-1))^(1/(2*k(i)));
        Z=min(max(X(j,:),-T),T)+normrnd(0,2*T/(mu*2),[1,n]);
        mean_est_gdp_2(j,i)=mean(Z);
        mean_gdp_2_err(j,i)=(mean(Z)-a*b)^2;
    end
end

mean_est=[mean_est_nonpriv;mean_est_alpha;mean_est_alpha_2;mean_est_alpha_4;mean_est_alpha_8;mean_est_alpha_16;mean_est_gdp;mean_est_gdp_2];

filename = sprintf('%s_%d%s','mean_est_n',n,'.xlsx');
writematrix(mean_est,filename)

plot(k,mean(mean_alpha_err),'yellow','LineWidth',1)
hold on
plot(k,mean(mean_alpha_2_err),'magenta','LineWidth',1)
hold on
plot(k,mean(mean_alpha_4_err),'red','LineWidth',1)
hold on
plot(k,mean(mean_alpha_8_err),'green','LineWidth',1)
hold on
plot(k,mean(mean_gdp_err),'blue','LineWidth',1)
hold on
plot(k,mean(mean_gdp_2_err),'black','LineWidth',1)
legend('0.4-LDP','0.8-LDP','1.6-LDP','3.2-LDP','0.5-GLDP','1-GLDP')
pbaspect([1 1 1])
set(gca,'fontsize',13)
title("Mean estimation error")
xlabel("moment")
ylabel("squared error")
hold off
